<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Ixudra\Curl\Facades\Curl;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Validator;
use Hash;
#HELPER
use Cron;
use Date;
use Fibonanci;
use Helper;
use Nfs;
use Payments;
use Wa;
#MODEL
use App\Models\User;
use App\Models\Cms\Role;

use App\Models\Wheel\SpinContent;
use App\Models\Wheel\SpinDraw;
use App\Models\Wheel\SpinFaq;
use App\Models\Wheel\SpinHistory;
use App\Models\Wheel\SpinPrize;
use App\Models\Wheel\SpinVoucher;

use App\Models\Cms\CmsLogs;

class DashboardController extends Controller
{
    public static function init(){
        $data['link']='dashboard';
        $data['title'] = 'dashboard';
        return $data;
    }
    
    public function index(){
        $data = Self::init();
        $data['select']             = 'Hari Ini';

        $data['history']            = SpinHistory::listDataToDay();
        $data['pengunjung']         = CmsLogs::whereDate('created_at',date('Y-m-d'))->count();
        $data['total_spin']         = SpinHistory::whereDate('created_at',date('Y-m-d'))->count();
        $data['voucher_used']       = SpinVoucher::whereDate('created_at',date('Y-m-d'))->where('status','used')->count();
        $data['voucher_not_used']   = SpinVoucher::whereDate('created_at',date('Y-m-d'))->where('status','not used')->count();
        return view('admin.dashboard.dashboard',$data);
    }

    public function all(){
        $data = Self::init();
        $data['select']             = 'Semua History';
        $data['history']            = SpinHistory::listData();
        $data['pengunjung']         = CmsLogs::count();
        $data['total_spin']         = SpinHistory::count();
        $data['voucher_used']       = SpinVoucher::where('status','used')->count();
        $data['voucher_not_used']   = SpinVoucher::where('status','not used')->count();

        return view('admin.dashboard.dashboard',$data);
    }
}
