<?php

namespace App\Models\Wheel;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class SpinPrize extends Model
{
    use HasFactory;
    protected $table = 'spin_prize';

    protected $fillable = [
        'id',
        'label',
        'status',
        'presentase',
        'sorter',
        'created_at',
        'updated_at'
    ];

    public function getIncrementing()
    {
        return false;
    }

    /**
     * Get the auto-incrementing key type.
     *
     * @return string
     */
    public function getKeyType()
    {
        return 'string';
    }

    public static function listData(){
        $data = SpinPrize::orderBy('sorter','asc')->get();

        return $data;
    }

    public static function insertData($request){
        $data = SpinPrize::create([
            'id' => (string) Str::uuid(),
            'label' => $request->label,
            'presentase' => $request->presentase,
            'status' => $request->status,
            'sorter' => $request->sorter,
        ]);

        return $data;
    }

    public static function updateData($request){
        $data = SpinPrize::where('id',$request->id)->update([
            'label' => $request->label,
            'presentase' => $request->presentase,
            'status' => $request->status,
            'sorter' => $request->sorter,
        ]);

        return $data;
    }

    public static function detailData($id){
        $data = SpinPrize::where('id',$id)->first();

        return $data;
    }
}
