@extends('template.content')
@section('content')

    <div class="row">
        <div class="col-sm-12 grid-margin stretch-card">
          <div class="card">
            <div class="card-body">
              <h4 class="card-title">{{$title}}</h4>
              <p class="card-description"> {{$subtitle}} </p>
              <form class="forms-sample" method="POST" action="{{url('admin/draw/store')}}" enctype="multipart/form-data">
                @csrf
                <div class="form-group">
                    <label for="type">type</label>
                    <select class="form-control" name="type" id="type" required>
                      <option value="presentase">presentase</option>
                      <option value="select prize">select prize</option>
                    </select>
                  </div>
                  
                <div class="form-group">
                    <label for="prize_id">Prize</label>
                    <select class="form-control" name="prize_id" id="prize_id" required>
                     <option value="" selected>pilih hadiah</option>
                      @foreach($prize as $priz)
                        <option value="{{$priz->id}}">{{$priz->label}}</option>
                      @endforeach
                    </select>
                  </div>
                  <div class="form-group">
                    <label for="voucher_id">Voucher / Code</label>
                    <select class="form-control" name="voucher_id" id="voucher_id" required>
                      <option value="" selected>pilih kupon</option>
                      @foreach($voucher as $voc)
                        <option value="{{$voc->id}}">{{$voc->voucher}} - {{$voc->member}}</option>
                      @endforeach
                    </select>
                  </div>
                <div class="form-group">
                    <label for="expired date">expired date <small>(optional default today)</small></label>
                    <input type="date" class="form-control" id="expired_date" value="{{date('Y-m-d')}}" name="expired_date" placeholder="expired_date">
                  </div>
                <hr>
                <div class="row mt-20">
                  <div class="col-sm-12">
                      <a class="btn btn-success" href="{{url('admin/draw')}}">Back</a>
                    <button type="submit" class="btn btn-primary">Submit</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
    </div>

    @push('js')

    <script>
      $(document).ready(function(){
        $("#prize_id").prop("disabled", true);
        $('body').on("change","#type",function(){
          var id = $(this).val();

          if(id == 'presentase'){
            $("#prize_id").prop("disabled", true);
          }else{
            $("#prize_id").prop("disabled", false);
          }
        });
      });
        
      </script>
    @endpush

@endsection