@extends('template.content')
@section('content')


<div class="mb-3">
  <nav class="navbar navbar-example navbar-expand-lg navbar-light bg-light">
      <div class="container-fluid" style="justify-content: start">
        <a class="btn btn-primary btn-sm" href="{{url('admin/draw/create')}}"><i class='bx bx-plus'></i>&nbsp;add data</a>
        </div>
    </nav>
  </div>

    <div class="row">
        <div class="col-sm-12">
                <div class="card">
                  <div class="card-body">
                    <h4 class="card-title">{{$title}}</h4>
                    <div class="table-responsive">
                      <table class="table" id="tabel">
                        <thead>
                          <tr>
                            <th>member</th>
                            <th>prize</th>
                            <th>voucher</th>
                            <th>type</th>
                            <th>expired_date</th>
                            <th>status</th>
                            <th>prize status</th>
                            <th>Action</th>
                          </tr>
                        </thead>
                        <tbody>
                          @foreach($row as $key)
                          <tr>
                            <td>{{$key->member}}</td>
                            <td>{{$key->prize}}</td>
                            <td>{{$key->voucher}}</td>
                            <td><b>by {{$key->type}}</b></td>
                            <td>{{$key->expired_date}}</td>
                            <td>@php echo Fibonanci::status($key->status); @endphp</td>
                            <td>@php echo Fibonanci::status($key->prize_status); @endphp</td>
                            <td>
                                <a href="{{url('admin/draw/edit/'.Nfs::Encrypt($key->id))}}" class="btn btn-sm btn-warning">edit</a>
                                </button>
                                <a href="javascript:void(0)" onclick="hapus('{{url('admin/draw/destroy/'.$key->id)}}')" class="btn btn-sm btn-danger">delete</a>
                            </td>
                          </tr>

                          @endforeach
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
        </div>
    </div>


    <!-- Modal -->

@push('js')
    <script>
      $(document).ready( function () {
        $('#tabel').DataTable({
          "pageLength": 25,
             searching: true,
             ordering:  true,
             paging: true,   
             "order": [[1, 'desc']],
             "columnDefs": [
                { "type": "date", "targets": [1] }//date column formatted like "03/23/2018 10:25:13 AM".
              ],     
        });
    });
    </script>
@endpush

@endsection