@extends('web.base')
@section('content')
    
 <!-- SOUND TRACK -->
 @if($spin=="false")

  <embed src="{{Fibonanci::content()['music']}}" loop="true" autostart="true" width="2" height="0" hidden>
    <audio controls autoplay hidden id="my_audio" loop="loop">
        <source src="{{Fibonanci::content()['music']}}" type="audio/mpeg">
        Your browser does not support the audio element.
    </audio>

  @endif
        	
    <div id="popup-container-history" class="popup-container" style="display: none;">
      <div id="popup-body" class="popup-body" style="height: 563px;">
          <div class="popup-close" onclick="close_popup_history()"><center><b>x</b></center></div>
          <div id="popup-header" class="popup-header">
              <center><h6 id="title-popup-win" style="padding: 10px;"><b>RIWAYAT SPIN</b></h6></center>
          </div>
          
          <div style="overflow-y: scroll;height: 91.5%;width: 100%;">
              <div style="padding: 5px;">
                <table style="width: 100%;">
                  <thead>
                    <tr>
                      <th align="center" valign="center" style="width: 10%; text-align: center;">NO</th>
                      <th align="center" valign="center" style="width: 50%;">NAME</th>
                      <th align="center" valign="center" style="width: 40%; text-align: center;">PRIZE</th>
                    </tr>
                  </thead>
                  <tbody id="history-container">
                  @php
                      $n = 1;
                  @endphp
                  @foreach($history as $his)
                    @php
                        if($his['member']){
                            $name = $his['member'];
                        }else{
                          $name = Fibonanci::randomName();
                        }
                    @endphp
                    <tr>
                      <td style="width: 10%; padding: 5px; text-align: center;">{{ $n++ }}</td>
                      <td style="width: 50%; padding: 5px;">{{ Fibonanci::replace_last_character($name) }}</td>
                      <td style="width: 40%; padding: 5px; text-align: center;">{{ $his['prize'] }}</td>
                    </tr>
                  @endforeach
                  </tbody>
                </table>
              </div>
          </div>
      </div>
    </div>

      <div class="container mt-20">
        <div class="row">
            <div class="col-sm-12">
          @if(session()->has('message'))
  
                @push('js')
                <script>
                  Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: "{{session('message')}}",
                    showConfirmButton: false,
                    timer: 3000
                  })
                </script>
            @endpush
  
          @else
  
              @if($spin=="false")
  
                    @push('js')
                        <script>
                              let music_home = document.getElementById("my_audio"); 
                              document.addEventListener("DOMContentLoaded", function(){
                                $(".swal2-modal").css('background-color', '#000');
                                Swal.fire({
                                      title: '{{str_replace(array("\r", "\n"), '', Nfs::content("welcome")["title"])}}',
                                      html: '<p>{{str_replace(array("\r", "\n"), '', Nfs::content("welcome")["description"])}}</p>',
                                      confirmButtonText:
                                      '<i class="fa fa-like"></i>Thank You',
                                      confirmButtonColor: 'goldenrod',
                                    }).then((result) => {
                                /* Read more about isConfirmed, isDenied below */
                                if (result.isConfirmed) {
                                    music_home.play(); 
                                  }})
                              });
                        </script>                  
                    @endpush
  
                @endif
  
          @endif
            </div>
        </div>
      </div>

      
  @if($spin=="false")
      <p class="h4 mb-4 font-weight-normal" id="headerTitle">Masukkan Kode Tiket:</p>
      <form class="form-signin" method="POST" action="{{url('spin')}}">
        @csrf

        <div class="form-group row">
          <div class="col-sm-12">
            <input type="text" name="name" placeholder="username" class="form-control form-control-lg" id="id_name" required>
          </div>
        </div>

        <div class="form-group row">
          <div class="col-sm-12">
            <input type="text" name="voucher" placeholder="code / voucher" class="form-control form-control-lg" id="id_voucher" required>
          </div>
        </div>

        <div class="row">
          <div class="col-md-6" style="margin-top: 20px;">
              <button type="submit" class="submit">
                <b>SPIN</b>
              </button>
          </div>
          <div class="col-md-6" style="margin-top: 20px;">
            <input type="button" value="RIWAYAT" class="submit" onclick="getHistory()" return false;></input>
          </div>
        </div>
      </form>

      <div class="row">

          <div class="col-md-12" style="margin-top: 20px;">
                <input type="button" value="Syarat & Ketentuan" class="submit" onclick="syarat()"return false;></input>
          </div>

          <div class="col-md-12" style="margin-top: 20px;">
            <input type="button" value="Whatsapp Admin" class="btn-back" 
            onClick="location.href='{{Nfs::content('whatsapp')}}'"></input>
         </div>

          <div class="col-md-12" style="margin-top: 20px;">
            <input type="button" value="KEMBALI KE SITUS" class="btn-back" 
            onClick="location.href='{{Nfs::content('link_home')}}'"></input>
         </div>

      </div>
  @endif

@push('js')
  <script type="text/javascript">
    function getCurrentURL () {
      return window.location.href
    }
    const url = getCurrentURL();
    const sp = url.split('/')[3];
    if (sp != 'draw') {
      introRotation(3600);
    }
  </script>
  <script type="text/javascript">
    $('button[type="submit"]').click(function() {
      document.getElementById('id_name').required = true;
      document.getElementById('id_voucher').required = true;
    });
    function getHistory(){
        document.getElementById('id_name').required = false;
        document.getElementById('id_voucher').required = false;
        $("#popup-container-history").fadeIn(1000);
    }
    
    function syarat(){
      Swal.fire({
        html:
          '<div style="border:solid black 1px">'+
          '<strong>{{Fibonanci::content()["name"]}}</strong> <br>'+
          '<p style="text-align: center;font-size: 14px">Syarat dan ketentuan</p>' +
          '<ol>'+
            @foreach($faq->toArray() as $f)
              '<li style="text-align: left;font-size: 12px;margin-top: 0px;">{{$f["content"]}}</li>'+
           @endforeach
		  '</ol>'+
          '</div>'+
          '<table class="table table-bordered" style="margin-top:10px">'+
          '<tr><th style="text-align: center;font-size: 16px">Hadiah lucky {{Fibonanci::content()["name"]}}</th></tr>'+
          @foreach($prize as $key)
            '<tr><td style="text-align: center;font-size: 12px">{{$key->label}}</td></tr>'+
          @endforeach
          '</table>',
          showCloseButton: true,
          confirmButtonText:
          '<i class="fa fa-thumbs-up"></i> saya setuju!',
          confirmButtonColor: '#be4d25',
      })
    }
  </script>
  <script type="text/javascript">
    function close_popup_history() {
      $("#popup-container-history").fadeOut(500);
      document.getElementById('id_name').required = true;
      document.getElementById('id_voucher').required = true;
		}
  </script>
  @if($spin == "true")
    <script type="text/javascript">
        spin("{{url('result/'.$draw_id.'/'.$result)}}", {{ $rotation }});
    </script>
  @else
    <script type="text/javascript">
         introRotation("{{Fibonanci::rumus_rotasi_start()}}")
    </script>

  @endif

  @endpush
  

  @endsection
