
<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
  <div class="row">
    <div class="col-sm-12">
      <div class="home-tab">
        <div class="d-sm-flex align-items-center justify-content-between border-bottom">
          <ul class="nav nav-tabs" role="tablist">
            <li class="nav-item">
              <a class="nav-link active ps-0" id="home-tab" data-bs-toggle="tab" href="#overview" role="tab" aria-controls="overview" aria-selected="true">Overview</a>
            </li>
          </ul>
          <div>
            <div class="btn-wrapper">
              <div>
                <div class="dropdown">
                  <button class="btn btn-success dropdown-toggle toggle-dark btn-lg mb-0 me-0"
                   type="button" id="dropdownMenuButton2" data-bs-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false"><?php echo e($select); ?></button>
                  <div class="dropdown-menu" aria-labelledby="dropdownMenuButton2">
                    <a class="dropdown-item" href="<?php echo e(url('dashboard')); ?>">Hari Ini</a>
                    <a class="dropdown-item" href="<?php echo e(url('dashboard_all')); ?>">Semua History</a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="tab-content tab-content-basic">
          <div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview"> 
            <div class="row">
              <div class="col-sm-12">
                <div class="statistics-details d-flex align-items-center justify-content-between">
                  <div>
                    <p class="statistics-title">Kupon Digunakan</p>
                    <h3 class="rate-percentage"><?php echo e($voucher_used); ?></h3>
                  </div>
                  <div>
                    <p class="statistics-title">Kupon Belum Digunakan</p>
                    <h3 class="rate-percentage"><?php echo e($voucher_not_used); ?></h3>
                  </div>
                  <div>
                    <p class="statistics-title">Total Spin</p>
                    <h3 class="rate-percentage"><?php echo e($total_spin); ?></h3>
                  </div>
                  <div>
                    <p class="statistics-title">Pengunjung website</p>
                    <h3 class="rate-percentage"><?php echo e($pengunjung); ?></h3>
                  </div>
                </div>
              </div>
            </div> 
          </div>
        </div>
      </div>
    </div>
  </div>


  <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <h4 class="card-title">History Spin All Users</h4>
            <div class="table-responsive">
              <table class="table" id="tabel">
                <thead>
                  <tr>
                    <th>Member</th>
                    <th>Voucher</th>
                    <th>Prize</th>
                    <th>Type</th>
                    <th>Date Spin</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>

                  <?php $__currentLoopData = $history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $his): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($his->member); ?></td>
                    <td><?php echo e($his->voucher); ?></td>
                    <td><?php echo e($his->prize); ?></td>
                    <td><?php echo Fibonanci::status($his->type); ?></td>
                    <td><?php echo e($his->date); ?></td>
                    <td> <a href="javascript:void(0)" onclick="hapus('<?php echo e(url('admin/history/destroy/'.$his->id)); ?>')" class="btn btn-sm btn-danger">delete</a></td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
  </div>
</div>


<?php $__env->startPush('js'); ?>
    <script>
      $(document).ready( function () {
        $('#tabel').DataTable({
          "pageLength": 25,
             searching: true,
             ordering:  true,
             paging: true,   
             "order": [[1, 'desc']],
             "columnDefs": [
                { "type": "date", "targets": [1] }//date column formatted like "03/23/2018 10:25:13 AM".
              ],     
        });
    });
    </script>

<script>
  $(document).ready( function () {
    $('#tabel2').DataTable({
      "pageLength": 25,
         searching: true,
         ordering:  true,
         paging: true,   
         "order": [[1, 'desc']],
         "columnDefs": [
            { "type": "date", "targets": [1] }//date column formatted like "03/23/2018 10:25:13 AM".
          ],     
    });
});
</script>
<?php $__env->stopPush(); ?>
    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.content', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SPIN\SPIN-WHEEL-LARAVEL9\resources\views/admin/dashboard/dashboard.blade.php ENDPATH**/ ?>