<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Yajra\Datatables\Datatables;
use Illuminate\Http\Request;

class MemberController extends Controller
{
    public static function json(Request $request)
    {
        $branch = $request->br;
        $result = DB::table('members')
            ->join('branches', 'branches.idbranch', '=', 'members.idbranch')
            ->join('banks', 'banks.idbank', '=', 'members.idbank')
            ->where('members.idbranch', '=', $branch)
            ->where('members.isactive', '=', 1)
            ->select('members.idmember', 'branches.branchname', 'members.fullname', 'members.username', 'members.email', 'members.phone', 'banks.bankcode', 'members.mbraccname', 'members.mbraccno', 'members.level', 'members.remark', 'members.isactive')
            ->get();
        $i = 0;
        $array = array();
        foreach ($result as $data) {
            $i++;
            $array[] = array(
                'no' => $i,
                'idmember' => $data->idmember,
                'branch' => $data->branchname,
                'fullname' => $data->fullname,
                'username' => $data->username,
                'email' => $data->email,
                'phone' => $data->phone,
                'bank' => $data->bankcode,
                'mbraccname' => $data->mbraccname,
                'mbraccno' => $data->mbraccno,
                'level' => $data->level,
                'remark' => $data->remark,
                'isactive' => $data->isactive
            );
        }
        return Datatables::of($array)->make(true);
    }
}
