<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Detail;

class MenusController extends Controller
{
    public static function json()
    {
        $refs = array();
        $list = array();
        $idgroup = Auth::user()->idgroup;
        $result = Detail::join('users', 'users.idgroup', 'details.idgroup')
            ->join('menus', 'menus.id', 'details.idmenu')
            ->where('details.idgroup', '=', $idgroup)
            ->where('details.hread', 1)
            ->where('menus.isactive', 1)
            ->orderBy('menus.mnorder')
            ->get();
        // $list[0]['section'] = 'Main Navigation';
        foreach ($result as $data) {
            $thisref = &$refs[$data['id']];
            $thisref['title'] = $data['title'];
            $thisref['root'] = $data['root'];
            $thisref['icon'] = $data['icon'];
            $thisref['page'] = $data['page'];
            $thisref['newtab'] = $data['newtab'];
            if ($data['parent'] == 0) {
                $list[$data['id']] = &$thisref;
                $thisref['bullet'] = 'dot';
            } else {
                $thisref['bullet'] = 'line';
                $refs[$data['parent']]['submenu'][$data['id']] = &$thisref;
            }
        }
        return array('items' => $list);
    }
}
