<?php

namespace App\Http\Controllers\Pages;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Yajra\Datatables\Datatables;
use Haruncpi\LaravelIdGenerator\IdGenerator;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

use App\Models\Bank;

class BankController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Bank';
        $page_description = 'This is Bank test page';
        $page_breadcrumbs = [
            ['page' => 'login-history', 'title' => 'Users'],
            ['page' => 'login-history', 'title' => 'History Login']
        ];
        return view('pages.bank.index', compact('page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('pages.bank.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'bankcode' => 'required|max:255',
            'bankname' => 'required|max:255'
        ]);
        if ($validator->fails()) {
            Alert::warning('Oops!', 'Something When Wrong!');
            return redirect('banks')->withErrors($validator);
        } else {
            if ($request->hasFile('icon')) {
                $newname = hash('sha256', rand(10,100) . strval(time()));
                $request->icon->storeAs('media/bank', $newname.'.'.$request->icon->guessExtension(), 'public');
            }else{
                return redirect('banks');
            }
            $id = IdGenerator::generate(['table' => 'banks', 'field' => 'idbank', 'length' => 6, 'prefix' => 'BANK']);
            Bank::create([
                'idbank' => $id,
                'bankcode' => strtoupper($request->bankcode),
                'bankname' => $request->bankname,
                'status' => $request->status == "on" ? 'online' : 'offline',
                'icon' => 'storage/media/bank/'.$newname.'.'.$request->icon->guessExtension(),
            ]);
            Helper::Activity('banks', $id, 'CREATE');
            Alert::success('Success!', 'Data has been saved!');
            return redirect('banks');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\bank  $bank
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $banks = DB::table('banks')->get();
        $i = 0;
        $array = array();
        foreach ($banks as $data) {
            $i++;
            $array[] = array(
                'no' => $i,
                'bankcode' => $data->bankcode,
                'bankname' => $data->bankname,
                'status' => $data->status,
                'icon' => $data->icon,
                'created_at' => $data->created_at,
                'updated_at' => $data->updated_at,
                'idbank' => $data->idbank
            );
        }
        return Datatables::of($array)->make(true);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\bank  $bank
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Bank::find($id);
        return view('pages.bank.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\bank  $bank
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        $bank = Bank::find($id)
            ->update([
                'bankcode' => $request->bankcode,
                'bankname' => $request->bankname,
                'status' => $request->status == "on" ? 'online' : 'offline',
                'updated_at' => date('Y-m-d H:i:s')
            ]);
        if ($request->hasFile('icon')) {
            $newname = hash('sha256', rand(10,100) . strval(time()));
            $request->icon->storeAs('media/bank', $newname.'.'.$request->icon->guessExtension(), 'public');

            Bank::find($id)
            ->update([
                'icon' => 'storage/media/bank/'.$newname.'.'.$request->icon->guessExtension()
            ]);
        }

        Helper::Activity('banks', $id, 'UPDATE');
        Alert::success('Success!', 'Data has been update!');
        return redirect('banks');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\bank  $bank
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Helper::Activity('banks', $id, 'DELETE');
        Bank::find($id)->delete();
    }
}
