<?php

namespace App\Http\Controllers\Pages;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\Branch;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\Datatables\Datatables;
use Haruncpi\LaravelIdGenerator\IdGenerator;
use RealRashid\SweetAlert\Facades\Alert;

class BranchController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */


    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Branch';
        $page_description = 'This is Brances test page';
        $page_breadcrumbs = [
            ['page' => 'login-history', 'title' => 'Users'],
            ['page' => 'login-history', 'title' => 'History Login']
        ];
        return view('pages.branch.index', compact('page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('pages.branch.create');
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'branchname' => 'required|max:255',
        ]);
        $id = IdGenerator::generate(['table' => 'branches', 'field' => 'idbranch', 'length' => 6, 'prefix' => 'BRC']);
        Branch::create([
            'idbranch' => $id,
            'branchname' => $request->branchname
        ]);
        Helper::Activity('branches', $id, 'CREATE');
        Alert::success('Success!', 'Data has been saved!');
        return redirect('branches');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $branches = DB::table('branches')->get();
        $i = 0;
        $array = array();
        foreach ($branches as $data) {
            $i++;
            $array[] = array(
                'no' => $i,
                'idbranch' => $data->idbranch,
                'branchname' => $data->branchname,
                'created_at' => $data->created_at,
                'updated_at' => $data->updated_at
            );
        }
        return Datatables::of($array)->make(true);
        // return Datatables::of($branchs)
        //     ->addIndexColumn()
        //     ->editColumn('created_at', function ($branch) {
        //         return [
        //             'display' => e($branch->created_at->format('Y-m-d H:i:s')),
        //             'timestamp' => $branch->created_at->timestamp
        //         ];
        //     })->make(true);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Branch::find($id);
        return view('pages.branch.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $brand = Branch::find($id)
            ->update([
                'branchname' => $request->branchname,
                'updated_at' => date('Y-m-d H:i:s')
            ]);
        Helper::Activity('branches', $id, 'UPDATE');
        Alert::success('Success!', 'Data has been update!');
        return redirect('branches');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Branch  $branch
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Helper::Activity('branches', $id, 'DELETE');
        Branch::find($id)->delete();
    }
}
