<?php

namespace App\Http\Controllers\Pages;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use Illuminate\Support\Facades\DB;
use App\Models\Branch;
use App\Helpers\Helper;

class CoinHistoryController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Coin History';
        $page_description = 'This is Data Coin History';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Coin History'],
            ['page' => 'coin-history', 'title' => 'Data Coin History']
        ];
        $branches = Branch::all();
        return view('pages.coinhistory.index', compact('branches', 'page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $dtfrom = $request->df;
        $dtto = $request->dt;
        $branch = $request->br;

        $transaction = DB::table('transactions')
            ->join('branches', 'branches.idbranch', '=', 'transactions.idbranch')
            ->leftjoin('products', 'products.idproduct', '=', 'transactions.idproduct')
            ->leftjoin('members', 'members.idmember', '=', 'transactions.idmember')
            ->leftjoin('accounts', 'accounts.idacc', '=', 'transactions.idacc')
            ->join('users', 'users.iduser', '=', 'transactions.iduser')
            ->where('transactions.trctype', '!=', 'TRANSFER')
            ->where('transactions.trctype', '!=', 'OTHER')
            ->select(
                'transactions.*',
                'branches.branchname',
                'products.productname',
                'members.mbraccname',
                'accounts.accname',
                'users.username',
            );
        if ($branch != '') {
            $res = $transaction->where('transactions.trcstatus', '=', 'CONFIRM')
                ->where('transactions.idbranch', '=', $branch)
                ->get();
        }
        if ($dtfrom != '' && $dtto != '') {
            $res = $transaction->where('transactions.trcstatus', '=', 'CONFIRM')
                ->whereBetween(DB::raw('LEFT(transactions.datetrc,10)'), [$dtfrom, $dtto])
                ->get();
        }

        $i = 0;
        $array = array();
        $dtopen = date('Y-m-d', strtotime('-1 days', strtotime($dtfrom)));
        $opening = @Helper::runCoin($branch, '2021-01-01', $dtopen);
        $array[] = array(
            'no' => '#',
            'datetrc' => '',
            'description' => 'OPENING BALANCE',
            'type' => 'OPENING',
            'debet' => '-',
            'credit' => '-',
            'cbalance' => number_format($opening),
            'user' => strtoupper(''),
        );
        foreach ($res as $data) {
            $i++;
            if ($data->dttype == 'DB') {
                $debet = 0;
                $credit = $data->amount;
                $opening = $opening - $credit;
            } else if ($data->dttype == 'CR') {
                $debet = $data->amount;
                $credit = 0;
                $opening = $opening + $debet;
            } else if ($data->dttype == '-' && $data->trctype == 'BONUS') {
                $debet = 0;
                $credit = $data->coin;
                $opening = $opening - $credit;
            }

            if ($data->trctype == 'DEPOSIT') {
                $description = $data->mbraccname;
            } else if ($data->trctype == 'WITHDRAWAL') {
                $description = $data->mbraccname;
            } else if ($data->trctype == 'TRANSFER') {
                if ($data->dttype == 'CR') {
                    $description = 'TRANSFER TO : ' . Helper::getTransfer($data->note, 'DB');
                } else if ($data->dttype == 'DB') {
                    $description = 'TRANSFER FROM : ' . Helper::getTransfer($data->note, 'CR');
                }
            } else if ($data->trctype == 'BONUS') {
                $description = $data->mbraccname;
            } else if ($data->trctype == 'OTHER') {
                $description = $data->remark;
            }

            $date = date_create($data->datetrc);
            $array[] = array(
                'no' => $i,
                'datetrc' => date_format($date, 'Y-m-d H:i:s'),
                'description' => strtoupper($description),
                'type' => $data->trctype,
                'debet' => @number_format($debet),
                'credit' => @number_format($credit),
                'cbalance' => number_format($opening),
                'user' => strtoupper($data->username)
            );
        }
        $array[] = array(
            'no' => 'Z',
            'datetrc' => '',
            'description' => 'CLOSING BALANCE',
            'type' => 'CLOSING',
            'debet' => '-',
            'credit' => '-',
            'cbalance' => number_format($opening),
            'user' => strtoupper(''),
        );
        return Datatables::of($array)->make(true);
    }
}
