<?php

namespace App\Http\Controllers\Pages;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\Datatables\Datatables;
use Haruncpi\LaravelIdGenerator\IdGenerator;
use Illuminate\Support\Facades\Validator;
use RealRashid\SweetAlert\Facades\Alert;

use App\Models\{Branch, Bank, Member, Ticket};

class MemberController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page = 'members';
        $page_title = 'Member';
        $page_description = 'This is Member test page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Member'],
            ['page' => 'users', 'title' => 'Data Member']
        ];
        $member = Member::all();
        return view('pages.member.index', compact('member', 'page_title', 'page_description', 'page_breadcrumbs', 'page'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $member = Member::all();
        $page = $request->cp;
        return view('pages.member.create', compact('member', 'page'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::Make($request->all(), [
            'username' => 'required|max:255',
        ]);
        if ($validator->fails()) {
            Alert::warning('Oops!', 'Something When Wrong!');
            if ($request->page == 'transaction') {
                return redirect($request->page)->withErrors($validator);
            } else {
                return redirect('members')->withErrors($validator);
            }
        } else {
            $id = IdGenerator::generate(['table' => 'members', 'field' => 'idmember', 'length' => 13, 'prefix' => 'MBR' . date('ym')]);
            Member::create([
                'idmember' => $id,
                'username' => $request->username,
            ]);
            Helper::Activity('members', $id, 'CREATE');
            Alert::success('Success!', 'Data Has Been Saved!');
            return redirect('tickets');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Member  $member
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $res = '';
        $query = $request->qr;
        $member = DB::table('members')
            ->select('members.idmember', 'members.username', 'members.created_at', 'members.updated_at');
        if ($query == 'null' || $bank == 'null' || $level == 'null') {
            $res = $member->orderByDesc('members.idmember')->take(10)->get();
        } else {
            if ($query != null) {
                $res = $member->where(function ($sql) use ($query) {
                    $sql->where('members.username', 'LIKE', '%' . $query . '%');
                })->get();
            }
        }
        $i = 0;
        $array = array();
        foreach ($res as $data) {
            $i++;
            $array[] = array(
                'no' => $i,
                'idmember' => $data->idmember,
                'username' => trim($data->username),
                'created_at' => $data->created_at,
                'updated_at' => $data->updated_at,
            );
        }
        return Datatables::of($array)->make(true);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Member  $member
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $page_title = 'Edit Member';
        $page_description = 'This is Edit Member page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Member'],
            ['page' => 'members', 'title' => 'Data Member'],
            ['page' => 'members/' . $id . '/edit', 'title' => 'Edit Member']
        ];
        $data = Member::find($id);
        return view('pages.member.edit', compact('data', 'page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Member  $member
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        Member::find($id)
            ->update([
                'username' => trim($request->username),
                'updated_at' => date('Y-m-d H:i:s')
            ]);
        Ticket::where('idticket', '=', $request->idticket)
            ->update([
                'fixed_reward' => $request->public_number,
                'updated_at' => date('Y-m-d H:i:s')
            ]);
        Alert::success('Success!', 'Data has been update!');
        
        return redirect('tickets');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Member  $member
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Helper::Activity('members', $id, 'DELETE');
        Member::find($id)->delete();
    }
}
