<?php

namespace App\Http\Controllers\Pages;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Yajra\Datatables\Datatables;
use Haruncpi\LaravelIdGenerator\IdGenerator;
use RealRashid\SweetAlert\Facades\Alert;

use App\Models\{Branch, Product};

class ProductController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page_title = 'Product';
        $page_description = 'This is Product test page';
        $page_breadcrumbs = [
            ['page' => 'products', 'title' => 'Master Data'],
            ['page' => 'products', 'title' => 'Product']
        ];
        return view('pages.product.index', compact('page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $branch = Branch::all();
        return view('pages.product.create', compact('branch'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'idbranch' => 'required|max:255',
            'productname' => 'required|max:255',
            'isactive' => 'required',
        ]);
        if ($validator->fails()) {
            Alert::warning('Oops!', 'Something When Wrong!');
            return redirect('products')->withErrors($validator);
        } else {
            $id = IdGenerator::generate(['table' => 'products', 'field' => 'idproduct', 'length' => 6, 'prefix' => 'PID']);
            Product::create([
                'idproduct' => $id,
                'idbranch' => $request->idbranch,
                'productname' => strtoupper($request->productname),
                'site1' => $request->site1,
                'site2' => $request->site2,
                'site3' => $request->site3,
                'isactive' => $request->isactive,
                'remark' => $request->remark,
            ]);
            Alert::success('Success!', 'Data Has Been Saved!');
            return redirect('products');
        }
    }
    /**
     * Display the specified resource.
     *
     * @param  \App\Models\product  $product
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $products = DB::table('products')
            ->join('branches', 'products.idbranch', '=', 'branches.idbranch')
            ->select('products.idproduct', 'branches.branchname', 'products.productname', 'products.site1', 'products.site2', 'products.site3', 'products.remark', 'products.isactive', 'products.created_at', 'products.updated_at', 'products.remark')
            ->get();
        $i = 0;
        $array = array();
        foreach ($products as $data) {
            $i++;
            $array[] = array(
                'no' => $i,
                'product' => $data->productname,
                'branch' => $data->branchname,
                'site1' => $data->site1,
                'site2' => $data->site2,
                'site3' => $data->site3,
                'remark' => $data->remark,
                'isactive' => $data->isactive,
                'created_at' => $data->created_at,
                'updated_at' => $data->updated_at,
                'idproduct' => $data->idproduct,
            );
        }
        return Datatables::of($array)->make(true);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $branch = Branch::all();
        $data = Product::find($id);
        return view('pages.product.edit', compact('data', 'branch'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        Product::find($id)
            ->update([
                'idbranch' => $request->idbranch,
                'productname' => $request->productname,
                'site1' => $request->site1,
                'site2' => $request->site2,
                'site3' => $request->site3,
                'remark' => $request->remark,
                'isactive' => $request->isactive,
                'updated_at' => date('Y-m-d H:i:s')
            ]);
        Alert::success('Success!', 'Data has been update!');
        return redirect('products');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Product::find($id)->delete();
    }
}
