<?php

namespace App\Http\Controllers\Pages;


use DB;
use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use Haruncpi\LaravelIdGenerator\IdGenerator;
use Illuminate\Support\Facades\Validator;
use RealRashid\SweetAlert\Facades\Alert;

use App\Models\Reward;

class RewardController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $page = 'rewards';
        $page_title = 'Reward';
        $page_description = 'This is Reward test page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Reward'],
            ['page' => 'users', 'title' => 'Data Reward']
        ];
        $reward = Reward::all();
        return view('pages.reward.index', compact('reward', 'page_title', 'page_description', 'page_breadcrumbs', 'page'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $reward = Reward::all();
        $page = $request->cp;
        return view('pages.reward.create', compact('reward', 'page'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::Make($request->all(), [
            'name' => 'required|max:255',
        ]);
        if ($validator->fails()) {
            Alert::warning('Oops!', 'Something When Wrong!');
            if ($request->page == 'transaction') {
                return redirect($request->page)->withErrors($validator);
            } else {
                return redirect('rewards')->withErrors($validator);
            }
        } else {
            $id = IdGenerator::generate(['table' => 'rewards', 'field' => 'idreward', 'length' => 13, 'prefix' => 'RWD' . date('ym')]);
            Reward::create([
                'idreward'      => $id,
                'name'           => $request->name,
                'color_bg'       => $request->color_bg,
                'color_text'     => $request->color_text,
                'persentase'     => $request->percentage,
                'max_occurance'  => $request->max_occurance,
                'occurance_type' => $request->occurance_type,
            ]);
            Helper::Activity('rewards', $id, 'CREATE');
            Alert::success('Success!', 'Data Has Been Saved!');
            if ($request->page == 'transaction') {
                return redirect($request->page);
            } else {
                return redirect('rewards');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Reward  $reward
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $res = '';
        $query = $request->qr;
        $reward = DB::table('rewards')->orderBy('public_number', 'asc');
        if ($query == 'null' || $bank == 'null' || $level == 'null') {
            $res = $reward->orderByDesc('rewards.idreward')->take(10)->get();
        } else {
            if ($query != null) {
                $res = $reward->where(function ($sql) use ($query) {
                    $sql->where('rewards.name', 'LIKE', '%' . $query . '%');
                })->get();
            }
        }
        $i = 0;
        $array = array();
        foreach ($res as $data) {
            $i++;
            $array[] = array(
                'no'             => $i,
                'idreward'       => $data->idreward,
                'name'           => $data->name,
                'color_bg'       => $data->color_bg,
                'color_text'     => $data->color_text,
                'persentase'     => trim($data->persentase).'%',
                'public_number'  => $data->public_number,
                'max_occurance'  => $data->max_occurance,
                'occurance_type' => $data->occurance_type,
                'created_at'     => $data->created_at,
                'updated_at'     => $data->updated_at,
            );
        }
        return Datatables::of($array)->make(true);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Reward  $reward
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $page_title = 'Edit Reward';
        $page_description = 'This is Edit Reward page';
        $page_breadcrumbs = [
            ['page' => '#', 'title' => 'Reward'],
            ['page' => 'rewards', 'title' => 'Data Reward'],
            ['page' => 'rewards/' . $id . '/edit', 'title' => 'Edit Reward']
        ];
        $data = Reward::find($id);
        return view('pages.reward.edit', compact('data', 'page_title', 'page_description', 'page_breadcrumbs'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Reward  $reward
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        Reward::where('public_number', $request->public_number)
            ->update([
                'public_number' => NULL,
            ]);
            
        Reward::find($id)
            ->update([
                'name'           => $request->name,
                'color_bg'       => $request->color_bg,
                'color_text'     => $request->color_text,
                'persentase'     => $request->percentage,
                'public_number'  => $request->public_number,
                'max_occurance'  => $request->max_occurance,
                'occurance_type' => $request->occurance_type,
                'updated_at'     => date('Y-m-d H:i:s')
            ]);
        Helper::Activity('rewards', $id, 'UPDATE');
        Alert::success('Success!', 'Data has been update!');
        return redirect('rewards');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Reward  $reward
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Helper::Activity('rewards', $id, 'DELETE');
        Reward::find($id)->delete();
    }
}
