<?php

namespace App\Imports;

use Haruncpi\LaravelIdGenerator\IdGenerator;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Models\{Bonus, Member};

class BonusesImport implements ToModel, WithHeadingRow
{
    /**
     * @param array $row
     *
     * @return Bonus|null
     */
    public function model(array $row)
    {
        $id = IdGenerator::generate(['table' => 'bonuses', 'field' => 'idbonus', 'length' => 13, 'prefix' => 'BNS' . date('m')]);
        $member = @Member::where('username', '=', $row['username'])->firstOrFail();
        $request = request()->all();
        return new Bonus([
            'idbonus'     => $id,
            'idbranch'     => $member->idbranch,
            'idmember'     => $member->idmember,
            'amount'     => $row['amount'],
            'dtfrom'     => $request['prdFrom'],
            'dtto'     => $request['prdTo'],
            'remark'     => $row['remark'],
            'iduser'     => Auth::user()->iduser,
            'bnstatus'     => 'DRAFT'
        ]);
    }
}
