<?php

namespace App\Imports;

use App\Models\Member;
use App\Models\Ticket;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\Importable;
use Haruncpi\LaravelIdGenerator\IdGenerator;

class MembersImport implements ToCollection,WithHeadingRow
{
    public function collection(Collection $rows)
    {
        foreach ($rows as $row)
        {
            $mbr = Member::where('username', '=', $row['username'])->first();
            if ($mbr === null) {
                $idmember = IdGenerator::generate(['table' => 'members', 'field' => 'idmember', 'length' => 13, 'prefix' => 'MBR' . date('ym')]);
                Member::create([
                    'idmember' => $idmember,
                    'username' => $row['username'],
                ]);

                if($row['tickets']){
                    for($i = 1; $i <= $row['tickets']; $i++){
                        $id = IdGenerator::generate(['table' => 'tickets', 'field' => 'idticket', 'length' => 13, 'prefix' => 'TCT' . date('ym')]);
                        $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                        $number_ticket = IdGenerator::generate(['table' => 'tickets', 'field' => 'number_ticket', 'length' => 8, 'prefix' => 'T' . substr(str_shuffle($permitted_chars), 0, 5)]);
                        Ticket::create([
                            'idticket' => $id,
                            'idmember' => $idmember,
                            'number_ticket' => $number_ticket,
                            'fixed_reward' => $row['rewards'],
                            'status' => 'active',
                        ]);
                    }
                }else{
                    $id = IdGenerator::generate(['table' => 'tickets', 'field' => 'idticket', 'length' => 13, 'prefix' => 'TCT' . date('ym')]);
                    $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                    $number_ticket = IdGenerator::generate(['table' => 'tickets', 'field' => 'number_ticket', 'length' => 8, 'prefix' => 'T' . substr(str_shuffle($permitted_chars), 0, 5)]);
                    Ticket::create([
                        'idticket' => $id,
                        'idmember' => $idmember,
                        'number_ticket' => $number_ticket,
                        'fixed_reward' => $row['rewards'],
                        'status' => 'active',
                    ]);
                }
            }else{
                if($row['tickets']){
                    for($i = 1; $i <= $row['tickets']; $i++){
                        $id = IdGenerator::generate(['table' => 'tickets', 'field' => 'idticket', 'length' => 13, 'prefix' => 'TCT' . date('ym')]);
                        $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                        $number_ticket = IdGenerator::generate(['table' => 'tickets', 'field' => 'number_ticket', 'length' => 8, 'prefix' => 'T' . substr(str_shuffle($permitted_chars), 0, 5)]);
                        Ticket::create([
                            'idticket' => $id,
                            'idmember' => $mbr->idmember,
                            'number_ticket' => $number_ticket,
                            'fixed_reward' => $row['rewards'],
                            'status' => 'active',
                        ]);
                    }
                }else{
                    $id = IdGenerator::generate(['table' => 'tickets', 'field' => 'idticket', 'length' => 13, 'prefix' => 'TCT' . date('ym')]);
                    $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
                    $number_ticket = IdGenerator::generate(['table' => 'tickets', 'field' => 'number_ticket', 'length' => 8, 'prefix' => 'T' . substr(str_shuffle($permitted_chars), 0, 5)]);
                    Ticket::create([
                        'idticket' => $id,
                        'idmember' => $mbr->idmember,
                        'number_ticket' => $number_ticket,
                        'fixed_reward' => $row['rewards'],
                        'status' => 'active',
                    ]);
                }
                
                
            }
            
        }
    }
}
